function CDX = set_sigma(CDX, sigma, dates)
% --------------------------------------------------------------------------------------------------
% Set mean volatility parameter for common and idionsyncratic factors
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% sigma     ... desired volatility
% dates     ... dates for which to set parameters, if sigma of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_sigma(CDX_NA_IG, 0.015)
% --------------------------------------------------------------------------------------------------

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 2)
    % Set value for common factor
    CDX.AJD_common_factor.sigma = sigma;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).AJD.sigma = sigma;
    end
    return
end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.sigma(used_pos_cdx,:) = sigma(used_pos_params,:);

% Set value for individual CDS
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cds, used_pos_params] = intersect_sorted(cds.dates{1}, dates);
    if (length(cds.ai) > 1)
        ai = cds.ai(used_pos_cds,:);
    else
        ai = cds.ai;
    end
    cds.AJD.sigma(used_pos_cds,:) = sqrt(ai) .* sigma(used_pos_params,:);
    CDX.portfolio(i) = cds;
    clear trash used_pos_cds used_pos_params
end